clear
clc

Q0 = 2.2;
z = 0.5;

Datos = xlsread('Ensayos Cycling');

Q = zeros(length(Datos(1,:))*0.5,length(Datos(:,1)));
Ah = zeros(length(Datos(1,:))*0.5,length(Datos(:,1)));

  for i=1:length(Datos(1,:))*0.5
      for j=1:length(Datos(:,1))
        Q(i,j) = Datos(j,2*i-1);
        Ah(i,j) = Datos(j,2*i);
      end
  end
  
Q = transpose(Q);
Ah = transpose(Ah);
Qloss = Q*Q0*0.01;
  
T = [273.15,288.15,318.15,333.15];
Crate = [0.5,2,6,10];

T1 = ones(1,length(Q(:,1)))*T(1);
T2 = ones(1,length(Q(:,1)))*T(2);
T3 = ones(1,length(Q(:,1)))*T(3);
T4 = ones(1,length(Q(:,1)))*T(4);
T = [T2;T3;T4;T2;T3;T4;T1;T3;T2;T3;T4];
T = transpose(T);

Crate1 = ones(1,length(Q(:,1)))*Crate(1);
Crate2 = ones(1,length(Q(:,1)))*Crate(2);
Crate3 = ones(1,length(Q(:,1)))*Crate(3);
Crate4 = ones(1,length(Q(:,1)))*Crate(4);
Crate = [Crate1;Crate1;Crate1;Crate2;Crate2;Crate2;Crate3;Crate3;Crate4;Crate4;Crate4];
Crate = transpose(Crate);

f = 5.980801169706742e+06;
g = 0.689770643186819;
h = -6.464711916845157e+03;
f = f*(exp(g)-1)/(g*exp(0.5));

A = @(x) x(1);
B = @(x) x(2);
C = @(x) x(3);
D = @(x) x(4);
E = @(x) x(5);
W1 = @(x) x(6);
W2 = @(x) x(7);
W3 = @(x) x(8);
W4 = @(x) x(9);

F = @(x)[

    ((x(1)*T(1,1)^2+x(2)*T(1,1)+x(3))*exp((x(4)*T(1,1)+x(5))*Crate(1,1))*Ah(1,1) + f*exp(h/T(1,1))*(Ah(1,1)/(2*x(6)*Q0*Crate(1,1)))^0.5) - Qloss(1,1);
    ((x(1)*T(2,1)^2+x(2)*T(2,1)+x(3))*exp((x(4)*T(2,1)+x(5))*Crate(2,1))*Ah(2,1) + f*exp(h/T(2,1))*(Ah(2,1)/(2*x(6)*Q0*Crate(2,1)))^0.5) - Qloss(2,1);
    ((x(1)*T(3,1)^2+x(2)*T(3,1)+x(3))*exp((x(4)*T(3,1)+x(5))*Crate(3,1))*Ah(3,1) + f*exp(h/T(3,1))*(Ah(3,1)/(2*x(6)*Q0*Crate(3,1)))^0.5) - Qloss(3,1);
    ((x(1)*T(4,1)^2+x(2)*T(4,1)+x(3))*exp((x(4)*T(4,1)+x(5))*Crate(4,1))*Ah(4,1) + f*exp(h/T(4,1))*(Ah(4,1)/(2*x(6)*Q0*Crate(4,1)))^0.5) - Qloss(4,1);
    ((x(1)*T(5,1)^2+x(2)*T(5,1)+x(3))*exp((x(4)*T(5,1)+x(5))*Crate(5,1))*Ah(5,1) + f*exp(h/T(5,1))*(Ah(5,1)/(2*x(6)*Q0*Crate(5,1)))^0.5) - Qloss(5,1);
    ((x(1)*T(6,1)^2+x(2)*T(6,1)+x(3))*exp((x(4)*T(6,1)+x(5))*Crate(6,1))*Ah(6,1) + f*exp(h/T(6,1))*(Ah(6,1)/(2*x(6)*Q0*Crate(6,1)))^0.5) - Qloss(6,1);
    ((x(1)*T(7,1)^2+x(2)*T(7,1)+x(3))*exp((x(4)*T(7,1)+x(5))*Crate(7,1))*Ah(7,1) + f*exp(h/T(7,1))*(Ah(7,1)/(2*x(6)*Q0*Crate(7,1)))^0.5) - Qloss(7,1);
    ((x(1)*T(8,1)^2+x(2)*T(8,1)+x(3))*exp((x(4)*T(8,1)+x(5))*Crate(8,1))*Ah(8,1) + f*exp(h/T(8,1))*(Ah(8,1)/(2*x(6)*Q0*Crate(8,1)))^0.5) - Qloss(8,1);
    ((x(1)*T(9,1)^2+x(2)*T(9,1)+x(3))*exp((x(4)*T(9,1)+x(5))*Crate(9,1))*Ah(9,1) + f*exp(h/T(9,1))*(Ah(9,1)/(2*x(6)*Q0*Crate(9,1)))^0.5) - Qloss(9,1);
    ((x(1)*T(10,1)^2+x(2)*T(10,1)+x(3))*exp((x(4)*T(10,1)+x(5))*Crate(10,1))*Ah(10,1) + f*exp(h/T(10,1))*(Ah(10,1)/(2*x(6)*Q0*Crate(10,1)))^0.5) - Qloss(10,1);
    ((x(1)*T(11,1)^2+x(2)*T(11,1)+x(3))*exp((x(4)*T(11,1)+x(5))*Crate(11,1))*Ah(11,1) + f*exp(h/T(11,1))*(Ah(11,1)/(2*x(6)*Q0*Crate(11,1)))^0.5) - Qloss(11,1);
    ((x(1)*T(12,1)^2+x(2)*T(12,1)+x(3))*exp((x(4)*T(12,1)+x(5))*Crate(12,1))*Ah(12,1) + f*exp(h/T(12,1))*(Ah(12,1)/(2*x(6)*Q0*Crate(12,1)))^0.5) - Qloss(12,1);
    ((x(1)*T(13,1)^2+x(2)*T(13,1)+x(3))*exp((x(4)*T(13,1)+x(5))*Crate(13,1))*Ah(13,1) + f*exp(h/T(13,1))*(Ah(13,1)/(2*x(6)*Q0*Crate(13,1)))^0.5) - Qloss(13,1);
    ((x(1)*T(14,1)^2+x(2)*T(14,1)+x(3))*exp((x(4)*T(14,1)+x(5))*Crate(14,1))*Ah(14,1) + f*exp(h/T(14,1))*(Ah(14,1)/(2*x(6)*Q0*Crate(14,1)))^0.5) - Qloss(14,1);
    ((x(1)*T(15,1)^2+x(2)*T(15,1)+x(3))*exp((x(4)*T(15,1)+x(5))*Crate(15,1))*Ah(15,1) + f*exp(h/T(15,1))*(Ah(15,1)/(2*x(6)*Q0*Crate(15,1)))^0.5) - Qloss(15,1);
    ((x(1)*T(16,1)^2+x(2)*T(16,1)+x(3))*exp((x(4)*T(16,1)+x(5))*Crate(16,1))*Ah(16,1) + f*exp(h/T(16,1))*(Ah(16,1)/(2*x(6)*Q0*Crate(16,1)))^0.5) - Qloss(16,1);
    ((x(1)*T(17,1)^2+x(2)*T(17,1)+x(3))*exp((x(4)*T(17,1)+x(5))*Crate(17,1))*Ah(17,1) + f*exp(h/T(17,1))*(Ah(17,1)/(2*x(6)*Q0*Crate(17,1)))^0.5) - Qloss(17,1);
    ((x(1)*T(18,1)^2+x(2)*T(18,1)+x(3))*exp((x(4)*T(18,1)+x(5))*Crate(18,1))*Ah(18,1) + f*exp(h/T(18,1))*(Ah(18,1)/(2*x(6)*Q0*Crate(18,1)))^0.5) - Qloss(18,1);
    ((x(1)*T(19,1)^2+x(2)*T(19,1)+x(3))*exp((x(4)*T(19,1)+x(5))*Crate(19,1))*Ah(19,1) + f*exp(h/T(19,1))*(Ah(19,1)/(2*x(6)*Q0*Crate(19,1)))^0.5) - Qloss(19,1);
    ((x(1)*T(20,1)^2+x(2)*T(20,1)+x(3))*exp((x(4)*T(20,1)+x(5))*Crate(20,1))*Ah(20,1) + f*exp(h/T(20,1))*(Ah(20,1)/(2*x(6)*Q0*Crate(20,1)))^0.5) - Qloss(20,1);
    ((x(1)*T(21,1)^2+x(2)*T(21,1)+x(3))*exp((x(4)*T(21,1)+x(5))*Crate(21,1))*Ah(21,1) + f*exp(h/T(21,1))*(Ah(21,1)/(2*x(6)*Q0*Crate(21,1)))^0.5) - Qloss(21,1);
    ((x(1)*T(22,1)^2+x(2)*T(22,1)+x(3))*exp((x(4)*T(22,1)+x(5))*Crate(22,1))*Ah(22,1) + f*exp(h/T(22,1))*(Ah(22,1)/(2*x(6)*Q0*Crate(22,1)))^0.5) - Qloss(22,1);
    ((x(1)*T(23,1)^2+x(2)*T(23,1)+x(3))*exp((x(4)*T(23,1)+x(5))*Crate(23,1))*Ah(23,1) + f*exp(h/T(23,1))*(Ah(23,1)/(2*x(6)*Q0*Crate(23,1)))^0.5) - Qloss(23,1);
    ((x(1)*T(24,1)^2+x(2)*T(24,1)+x(3))*exp((x(4)*T(24,1)+x(5))*Crate(24,1))*Ah(24,1) + f*exp(h/T(24,1))*(Ah(24,1)/(2*x(6)*Q0*Crate(24,1)))^0.5) - Qloss(24,1);
    ((x(1)*T(25,1)^2+x(2)*T(25,1)+x(3))*exp((x(4)*T(25,1)+x(5))*Crate(25,1))*Ah(25,1) + f*exp(h/T(25,1))*(Ah(25,1)/(2*x(6)*Q0*Crate(25,1)))^0.5) - Qloss(25,1);
    ((x(1)*T(26,1)^2+x(2)*T(26,1)+x(3))*exp((x(4)*T(26,1)+x(5))*Crate(26,1))*Ah(26,1) + f*exp(h/T(26,1))*(Ah(26,1)/(2*x(6)*Q0*Crate(26,1)))^0.5) - Qloss(26,1);
    ((x(1)*T(27,1)^2+x(2)*T(27,1)+x(3))*exp((x(4)*T(27,1)+x(5))*Crate(27,1))*Ah(27,1) + f*exp(h/T(27,1))*(Ah(27,1)/(2*x(6)*Q0*Crate(27,1)))^0.5) - Qloss(27,1);
    ((x(1)*T(28,1)^2+x(2)*T(28,1)+x(3))*exp((x(4)*T(28,1)+x(5))*Crate(28,1))*Ah(28,1) + f*exp(h/T(28,1))*(Ah(28,1)/(2*x(6)*Q0*Crate(28,1)))^0.5) - Qloss(28,1);
    ((x(1)*T(29,1)^2+x(2)*T(29,1)+x(3))*exp((x(4)*T(29,1)+x(5))*Crate(29,1))*Ah(29,1) + f*exp(h/T(29,1))*(Ah(29,1)/(2*x(6)*Q0*Crate(29,1)))^0.5) - Qloss(29,1);
    ((x(1)*T(30,1)^2+x(2)*T(30,1)+x(3))*exp((x(4)*T(30,1)+x(5))*Crate(30,1))*Ah(30,1) + f*exp(h/T(30,1))*(Ah(30,1)/(2*x(6)*Q0*Crate(30,1)))^0.5) - Qloss(30,1);
    ((x(1)*T(31,1)^2+x(2)*T(31,1)+x(3))*exp((x(4)*T(31,1)+x(5))*Crate(31,1))*Ah(31,1) + f*exp(h/T(31,1))*(Ah(31,1)/(2*x(6)*Q0*Crate(31,1)))^0.5) - Qloss(31,1);
 
    ((x(1)*T(1,2)^2+x(2)*T(1,2)+x(3))*exp((x(4)*T(1,2)+x(5))*Crate(1,2))*Ah(1,2) + f*exp(h/T(1,2))*(Ah(1,2)/(2*x(6)*Q0*Crate(1,2)))^0.5) - Qloss(1,2);
    ((x(1)*T(2,2)^2+x(2)*T(2,2)+x(3))*exp((x(4)*T(2,2)+x(5))*Crate(2,2))*Ah(2,2) + f*exp(h/T(2,2))*(Ah(2,2)/(2*x(6)*Q0*Crate(2,2)))^0.5) - Qloss(2,2);
    ((x(1)*T(3,2)^2+x(2)*T(3,2)+x(3))*exp((x(4)*T(3,2)+x(5))*Crate(3,2))*Ah(3,2) + f*exp(h/T(3,2))*(Ah(3,2)/(2*x(6)*Q0*Crate(3,2)))^0.5) - Qloss(3,2);
    ((x(1)*T(4,2)^2+x(2)*T(4,2)+x(3))*exp((x(4)*T(4,2)+x(5))*Crate(4,2))*Ah(4,2) + f*exp(h/T(4,2))*(Ah(4,2)/(2*x(6)*Q0*Crate(4,2)))^0.5) - Qloss(4,2);
    ((x(1)*T(5,2)^2+x(2)*T(5,2)+x(3))*exp((x(4)*T(5,2)+x(5))*Crate(5,2))*Ah(5,2) + f*exp(h/T(5,2))*(Ah(5,2)/(2*x(6)*Q0*Crate(5,2)))^0.5) - Qloss(5,2);
    ((x(1)*T(6,2)^2+x(2)*T(6,2)+x(3))*exp((x(4)*T(6,2)+x(5))*Crate(6,2))*Ah(6,2) + f*exp(h/T(6,2))*(Ah(6,2)/(2*x(6)*Q0*Crate(6,2)))^0.5) - Qloss(6,2);
    ((x(1)*T(7,2)^2+x(2)*T(7,2)+x(3))*exp((x(4)*T(7,2)+x(5))*Crate(7,2))*Ah(7,2) + f*exp(h/T(7,2))*(Ah(7,2)/(2*x(6)*Q0*Crate(7,2)))^0.5) - Qloss(7,2);
    ((x(1)*T(8,2)^2+x(2)*T(8,2)+x(3))*exp((x(4)*T(8,2)+x(5))*Crate(8,2))*Ah(8,2) + f*exp(h/T(8,2))*(Ah(8,2)/(2*x(6)*Q0*Crate(8,2)))^0.5) - Qloss(8,2);
    ((x(1)*T(9,2)^2+x(2)*T(9,2)+x(3))*exp((x(4)*T(9,2)+x(5))*Crate(9,2))*Ah(9,2) + f*exp(h/T(9,2))*(Ah(9,2)/(2*x(6)*Q0*Crate(9,2)))^0.5) - Qloss(9,2);
    ((x(1)*T(10,2)^2+x(2)*T(10,2)+x(3))*exp((x(4)*T(10,2)+x(5))*Crate(10,2))*Ah(10,2) + f*exp(h/T(10,2))*(Ah(10,2)/(2*x(6)*Q0*Crate(10,2)))^0.5) - Qloss(10,2);
    ((x(1)*T(11,2)^2+x(2)*T(11,2)+x(3))*exp((x(4)*T(11,2)+x(5))*Crate(11,2))*Ah(11,2) + f*exp(h/T(11,2))*(Ah(11,2)/(2*x(6)*Q0*Crate(11,2)))^0.5) - Qloss(11,2);
    ((x(1)*T(12,2)^2+x(2)*T(12,2)+x(3))*exp((x(4)*T(12,2)+x(5))*Crate(12,2))*Ah(12,2) + f*exp(h/T(12,2))*(Ah(12,2)/(2*x(6)*Q0*Crate(12,2)))^0.5) - Qloss(12,2);
    ((x(1)*T(13,2)^2+x(2)*T(13,2)+x(3))*exp((x(4)*T(13,2)+x(5))*Crate(13,2))*Ah(13,2) + f*exp(h/T(13,2))*(Ah(13,2)/(2*x(6)*Q0*Crate(13,2)))^0.5) - Qloss(13,2);
    ((x(1)*T(14,2)^2+x(2)*T(14,2)+x(3))*exp((x(4)*T(14,2)+x(5))*Crate(14,2))*Ah(14,2) + f*exp(h/T(14,2))*(Ah(14,2)/(2*x(6)*Q0*Crate(14,2)))^0.5) - Qloss(14,2);
    ((x(1)*T(15,2)^2+x(2)*T(15,2)+x(3))*exp((x(4)*T(15,2)+x(5))*Crate(15,2))*Ah(15,2) + f*exp(h/T(15,2))*(Ah(15,2)/(2*x(6)*Q0*Crate(15,2)))^0.5) - Qloss(15,2);
    ((x(1)*T(16,2)^2+x(2)*T(16,2)+x(3))*exp((x(4)*T(16,2)+x(5))*Crate(16,2))*Ah(16,2) + f*exp(h/T(16,2))*(Ah(16,2)/(2*x(6)*Q0*Crate(16,2)))^0.5) - Qloss(16,2);
    ((x(1)*T(17,2)^2+x(2)*T(17,2)+x(3))*exp((x(4)*T(17,2)+x(5))*Crate(17,2))*Ah(17,2) + f*exp(h/T(17,2))*(Ah(17,2)/(2*x(6)*Q0*Crate(17,2)))^0.5) - Qloss(17,2);
    ((x(1)*T(18,2)^2+x(2)*T(18,2)+x(3))*exp((x(4)*T(18,2)+x(5))*Crate(18,2))*Ah(18,2) + f*exp(h/T(18,2))*(Ah(18,2)/(2*x(6)*Q0*Crate(18,2)))^0.5) - Qloss(18,2);
    ((x(1)*T(19,2)^2+x(2)*T(19,2)+x(3))*exp((x(4)*T(19,2)+x(5))*Crate(19,2))*Ah(19,2) + f*exp(h/T(19,2))*(Ah(19,2)/(2*x(6)*Q0*Crate(19,2)))^0.5) - Qloss(19,2);
    ((x(1)*T(20,2)^2+x(2)*T(20,2)+x(3))*exp((x(4)*T(20,2)+x(5))*Crate(20,2))*Ah(20,2) + f*exp(h/T(20,2))*(Ah(20,2)/(2*x(6)*Q0*Crate(20,2)))^0.5) - Qloss(20,2);
    ((x(1)*T(21,2)^2+x(2)*T(21,2)+x(3))*exp((x(4)*T(21,2)+x(5))*Crate(21,2))*Ah(21,2) + f*exp(h/T(21,2))*(Ah(21,2)/(2*x(6)*Q0*Crate(21,2)))^0.5) - Qloss(21,2);
    ((x(1)*T(22,2)^2+x(2)*T(22,2)+x(3))*exp((x(4)*T(22,2)+x(5))*Crate(22,2))*Ah(22,2) + f*exp(h/T(22,2))*(Ah(22,2)/(2*x(6)*Q0*Crate(22,2)))^0.5) - Qloss(22,2);
    ((x(1)*T(23,2)^2+x(2)*T(23,2)+x(3))*exp((x(4)*T(23,2)+x(5))*Crate(23,2))*Ah(23,2) + f*exp(h/T(23,2))*(Ah(23,2)/(2*x(6)*Q0*Crate(23,2)))^0.5) - Qloss(23,2);
    ((x(1)*T(24,2)^2+x(2)*T(24,2)+x(3))*exp((x(4)*T(24,2)+x(5))*Crate(24,2))*Ah(24,2) + f*exp(h/T(24,2))*(Ah(24,2)/(2*x(6)*Q0*Crate(24,2)))^0.5) - Qloss(24,2);
    ((x(1)*T(25,2)^2+x(2)*T(25,2)+x(3))*exp((x(4)*T(25,2)+x(5))*Crate(25,2))*Ah(25,2) + f*exp(h/T(25,2))*(Ah(25,2)/(2*x(6)*Q0*Crate(25,2)))^0.5) - Qloss(25,2);
    ((x(1)*T(26,2)^2+x(2)*T(26,2)+x(3))*exp((x(4)*T(26,2)+x(5))*Crate(26,2))*Ah(26,2) + f*exp(h/T(26,2))*(Ah(26,2)/(2*x(6)*Q0*Crate(26,2)))^0.5) - Qloss(26,2);
    ((x(1)*T(27,2)^2+x(2)*T(27,2)+x(3))*exp((x(4)*T(27,2)+x(5))*Crate(27,2))*Ah(27,2) + f*exp(h/T(27,2))*(Ah(27,2)/(2*x(6)*Q0*Crate(27,2)))^0.5) - Qloss(27,2);
    ((x(1)*T(28,2)^2+x(2)*T(28,2)+x(3))*exp((x(4)*T(28,2)+x(5))*Crate(28,2))*Ah(28,2) + f*exp(h/T(28,2))*(Ah(28,2)/(2*x(6)*Q0*Crate(28,2)))^0.5) - Qloss(28,2);
    
    ((x(1)*T(1,3)^2+x(2)*T(1,3)+x(3))*exp((x(4)*T(1,3)+x(5))*Crate(1,3))*Ah(1,3) + f*exp(h/T(1,3))*(Ah(1,3)/(2*x(6)*Q0*Crate(1,3)))^0.5) - Qloss(1,3);
    ((x(1)*T(2,3)^2+x(2)*T(2,3)+x(3))*exp((x(4)*T(2,3)+x(5))*Crate(2,3))*Ah(2,3) + f*exp(h/T(2,3))*(Ah(2,3)/(2*x(6)*Q0*Crate(2,3)))^0.5) - Qloss(2,3);
    ((x(1)*T(3,3)^2+x(2)*T(3,3)+x(3))*exp((x(4)*T(3,3)+x(5))*Crate(3,3))*Ah(3,3) + f*exp(h/T(3,3))*(Ah(3,3)/(2*x(6)*Q0*Crate(3,3)))^0.5) - Qloss(3,3);
    ((x(1)*T(4,3)^2+x(2)*T(4,3)+x(3))*exp((x(4)*T(4,3)+x(5))*Crate(4,3))*Ah(4,3) + f*exp(h/T(4,3))*(Ah(4,3)/(2*x(6)*Q0*Crate(4,3)))^0.5) - Qloss(4,3);
    ((x(1)*T(5,3)^2+x(2)*T(5,3)+x(3))*exp((x(4)*T(5,3)+x(5))*Crate(5,3))*Ah(5,3) + f*exp(h/T(5,3))*(Ah(5,3)/(2*x(6)*Q0*Crate(5,3)))^0.5) - Qloss(5,3);
    ((x(1)*T(6,3)^2+x(2)*T(6,3)+x(3))*exp((x(4)*T(6,3)+x(5))*Crate(6,3))*Ah(6,3) + f*exp(h/T(6,3))*(Ah(6,3)/(2*x(6)*Q0*Crate(6,3)))^0.5) - Qloss(6,3);
    ((x(1)*T(7,3)^2+x(2)*T(7,3)+x(3))*exp((x(4)*T(7,3)+x(5))*Crate(7,3))*Ah(7,3) + f*exp(h/T(7,3))*(Ah(7,3)/(2*x(6)*Q0*Crate(7,3)))^0.5) - Qloss(7,3);
    ((x(1)*T(8,3)^2+x(2)*T(8,3)+x(3))*exp((x(4)*T(8,3)+x(5))*Crate(8,3))*Ah(8,3) + f*exp(h/T(8,3))*(Ah(8,3)/(2*x(6)*Q0*Crate(8,3)))^0.5) - Qloss(8,3);
    ((x(1)*T(9,3)^2+x(2)*T(9,3)+x(3))*exp((x(4)*T(9,3)+x(5))*Crate(9,3))*Ah(9,3) + f*exp(h/T(9,3))*(Ah(9,3)/(2*x(6)*Q0*Crate(9,3)))^0.5) - Qloss(9,3);
    ((x(1)*T(10,3)^2+x(2)*T(10,3)+x(3))*exp((x(4)*T(10,3)+x(5))*Crate(10,3))*Ah(10,3) + f*exp(h/T(10,3))*(Ah(10,3)/(2*x(6)*Q0*Crate(10,3)))^0.5) - Qloss(10,3);
    ((x(1)*T(11,3)^2+x(2)*T(11,3)+x(3))*exp((x(4)*T(11,3)+x(5))*Crate(11,3))*Ah(11,3) + f*exp(h/T(11,3))*(Ah(11,3)/(2*x(6)*Q0*Crate(11,3)))^0.5) - Qloss(11,3);
    ((x(1)*T(12,3)^2+x(2)*T(12,3)+x(3))*exp((x(4)*T(12,3)+x(5))*Crate(12,3))*Ah(12,3) + f*exp(h/T(12,3))*(Ah(12,3)/(2*x(6)*Q0*Crate(12,3)))^0.5) - Qloss(12,3);
    ((x(1)*T(13,3)^2+x(2)*T(13,3)+x(3))*exp((x(4)*T(13,3)+x(5))*Crate(13,3))*Ah(13,3) + f*exp(h/T(13,3))*(Ah(13,3)/(2*x(6)*Q0*Crate(13,3)))^0.5) - Qloss(13,3);
    ((x(1)*T(14,3)^2+x(2)*T(14,3)+x(3))*exp((x(4)*T(14,3)+x(5))*Crate(14,3))*Ah(14,3) + f*exp(h/T(14,3))*(Ah(14,3)/(2*x(6)*Q0*Crate(14,3)))^0.5) - Qloss(14,3);
    ((x(1)*T(15,3)^2+x(2)*T(15,3)+x(3))*exp((x(4)*T(15,3)+x(5))*Crate(15,3))*Ah(15,3) + f*exp(h/T(15,3))*(Ah(15,3)/(2*x(6)*Q0*Crate(15,3)))^0.5) - Qloss(15,3);
    ((x(1)*T(16,3)^2+x(2)*T(16,3)+x(3))*exp((x(4)*T(16,3)+x(5))*Crate(16,3))*Ah(16,3) + f*exp(h/T(16,3))*(Ah(16,3)/(2*x(6)*Q0*Crate(16,3)))^0.5) - Qloss(16,3);
    ((x(1)*T(17,3)^2+x(2)*T(17,3)+x(3))*exp((x(4)*T(17,3)+x(5))*Crate(17,3))*Ah(17,3) + f*exp(h/T(17,3))*(Ah(17,3)/(2*x(6)*Q0*Crate(17,3)))^0.5) - Qloss(17,3);
    ((x(1)*T(18,3)^2+x(2)*T(18,3)+x(3))*exp((x(4)*T(18,3)+x(5))*Crate(18,3))*Ah(18,3) + f*exp(h/T(18,3))*(Ah(18,3)/(2*x(6)*Q0*Crate(18,3)))^0.5) - Qloss(18,3);
    ((x(1)*T(19,3)^2+x(2)*T(19,3)+x(3))*exp((x(4)*T(19,3)+x(5))*Crate(19,3))*Ah(19,3) + f*exp(h/T(19,3))*(Ah(19,3)/(2*x(6)*Q0*Crate(19,3)))^0.5) - Qloss(19,3);
    ((x(1)*T(20,3)^2+x(2)*T(20,3)+x(3))*exp((x(4)*T(20,3)+x(5))*Crate(20,3))*Ah(20,3) + f*exp(h/T(20,3))*(Ah(20,3)/(2*x(6)*Q0*Crate(20,3)))^0.5) - Qloss(20,3);
    ((x(1)*T(21,3)^2+x(2)*T(21,3)+x(3))*exp((x(4)*T(21,3)+x(5))*Crate(21,3))*Ah(21,3) + f*exp(h/T(21,3))*(Ah(21,3)/(2*x(6)*Q0*Crate(21,3)))^0.5) - Qloss(21,3);
    ((x(1)*T(22,3)^2+x(2)*T(22,3)+x(3))*exp((x(4)*T(22,3)+x(5))*Crate(22,3))*Ah(22,3) + f*exp(h/T(22,3))*(Ah(22,3)/(2*x(6)*Q0*Crate(22,3)))^0.5) - Qloss(22,3);
    ((x(1)*T(23,3)^2+x(2)*T(23,3)+x(3))*exp((x(4)*T(23,3)+x(5))*Crate(23,3))*Ah(23,3) + f*exp(h/T(23,3))*(Ah(23,3)/(2*x(6)*Q0*Crate(23,3)))^0.5) - Qloss(23,3);
    ((x(1)*T(24,3)^2+x(2)*T(24,3)+x(3))*exp((x(4)*T(24,3)+x(5))*Crate(24,3))*Ah(24,3) + f*exp(h/T(24,3))*(Ah(24,3)/(2*x(6)*Q0*Crate(24,3)))^0.5) - Qloss(24,3);
 
    ((x(1)*T(1,4)^2+x(2)*T(1,4)+x(3))*exp((x(4)*T(1,4)+x(5))*Crate(1,4))*Ah(1,4) + f*exp(h/T(1,4))*(Ah(1,4)/(2*x(7)*Q0*Crate(1,4)))^0.5) - Qloss(1,4);
    ((x(1)*T(2,4)^2+x(2)*T(2,4)+x(3))*exp((x(4)*T(2,4)+x(5))*Crate(2,4))*Ah(2,4) + f*exp(h/T(2,4))*(Ah(2,4)/(2*x(7)*Q0*Crate(2,4)))^0.5) - Qloss(2,4);
    
    ((x(1)*T(1,5)^2+x(2)*T(1,5)+x(3))*exp((x(4)*T(1,5)+x(5))*Crate(1,5))*Ah(1,5) + f*exp(h/T(1,5))*(Ah(1,5)/(2*x(7)*Q0*Crate(1,5)))^0.5) - Qloss(1,5);
    ((x(1)*T(2,5)^2+x(2)*T(2,5)+x(3))*exp((x(4)*T(2,5)+x(5))*Crate(2,5))*Ah(2,5) + f*exp(h/T(2,5))*(Ah(2,5)/(2*x(7)*Q0*Crate(2,5)))^0.5) - Qloss(2,5);
    ((x(1)*T(3,5)^2+x(2)*T(3,5)+x(3))*exp((x(4)*T(3,5)+x(5))*Crate(3,5))*Ah(3,5) + f*exp(h/T(3,5))*(Ah(3,5)/(2*x(7)*Q0*Crate(3,5)))^0.5) - Qloss(3,5);
   
    ((x(1)*T(1,6)^2+x(2)*T(1,6)+x(3))*exp((x(4)*T(1,6)+x(5))*Crate(1,6))*Ah(1,6) + f*exp(h/T(1,6))*(Ah(1,6)/(2*x(7)*Q0*Crate(1,6)))^0.5) - Qloss(1,6);
    ((x(1)*T(2,6)^2+x(2)*T(2,6)+x(3))*exp((x(4)*T(2,6)+x(5))*Crate(2,6))*Ah(2,6) + f*exp(h/T(2,6))*(Ah(2,6)/(2*x(7)*Q0*Crate(2,6)))^0.5) - Qloss(2,6);
    ((x(1)*T(3,6)^2+x(2)*T(3,6)+x(3))*exp((x(4)*T(3,6)+x(5))*Crate(3,6))*Ah(3,6) + f*exp(h/T(3,6))*(Ah(3,6)/(2*x(7)*Q0*Crate(3,6)))^0.5) - Qloss(3,6);
    ((x(1)*T(4,6)^2+x(2)*T(4,6)+x(3))*exp((x(4)*T(4,6)+x(5))*Crate(4,6))*Ah(4,6) + f*exp(h/T(4,6))*(Ah(4,6)/(2*x(7)*Q0*Crate(4,6)))^0.5) - Qloss(4,6);
    ((x(1)*T(5,6)^2+x(2)*T(5,6)+x(3))*exp((x(4)*T(5,6)+x(5))*Crate(5,6))*Ah(5,6) + f*exp(h/T(5,6))*(Ah(5,6)/(2*x(7)*Q0*Crate(5,6)))^0.5) - Qloss(5,6);
    ((x(1)*T(6,6)^2+x(2)*T(6,6)+x(3))*exp((x(4)*T(6,6)+x(5))*Crate(6,6))*Ah(6,6) + f*exp(h/T(6,6))*(Ah(6,6)/(2*x(7)*Q0*Crate(6,6)))^0.5) - Qloss(6,6);
    ((x(1)*T(7,6)^2+x(2)*T(7,6)+x(3))*exp((x(4)*T(7,6)+x(5))*Crate(7,6))*Ah(7,6) + f*exp(h/T(7,6))*(Ah(7,6)/(2*x(7)*Q0*Crate(7,6)))^0.5) - Qloss(7,6);
 
    ((x(1)*T(1,7)^2+x(2)*T(1,7)+x(3))*exp((x(4)*T(1,7)+x(5))*Crate(1,7))*Ah(1,7) + f*exp(h/T(1,7))*(Ah(1,7)/(2*x(8)*Q0*Crate(1,7)))^0.5) - Qloss(1,7);
    ((x(1)*T(2,7)^2+x(2)*T(2,7)+x(3))*exp((x(4)*T(2,7)+x(5))*Crate(2,7))*Ah(2,7) + f*exp(h/T(2,7))*(Ah(2,7)/(2*x(8)*Q0*Crate(2,7)))^0.5) - Qloss(2,7);
    ((x(1)*T(3,7)^2+x(2)*T(3,7)+x(3))*exp((x(4)*T(3,7)+x(5))*Crate(3,7))*Ah(3,7) + f*exp(h/T(3,7))*(Ah(3,7)/(2*x(8)*Q0*Crate(3,7)))^0.5) - Qloss(3,7);
    ((x(1)*T(4,7)^2+x(2)*T(4,7)+x(3))*exp((x(4)*T(4,7)+x(5))*Crate(4,7))*Ah(4,7) + f*exp(h/T(4,7))*(Ah(4,7)/(2*x(8)*Q0*Crate(4,7)))^0.5) - Qloss(4,7);
    ((x(1)*T(5,7)^2+x(2)*T(5,7)+x(3))*exp((x(4)*T(5,7)+x(5))*Crate(5,7))*Ah(5,7) + f*exp(h/T(5,7))*(Ah(5,7)/(2*x(8)*Q0*Crate(5,7)))^0.5) - Qloss(5,7);
    ((x(1)*T(6,7)^2+x(2)*T(6,7)+x(3))*exp((x(4)*T(6,7)+x(5))*Crate(6,7))*Ah(6,7) + f*exp(h/T(6,7))*(Ah(6,7)/(2*x(8)*Q0*Crate(6,7)))^0.5) - Qloss(6,7);
  
    ((x(1)*T(1,8)^2+x(2)*T(1,8)+x(3))*exp((x(4)*T(1,8)+x(5))*Crate(1,8))*Ah(1,8) + f*exp(h/T(1,8))*(Ah(1,8)/(2*x(8)*Q0*Crate(1,8)))^0.5) - Qloss(1,8);
    ((x(1)*T(2,8)^2+x(2)*T(2,8)+x(3))*exp((x(4)*T(2,8)+x(5))*Crate(2,8))*Ah(2,8) + f*exp(h/T(2,8))*(Ah(2,8)/(2*x(8)*Q0*Crate(2,8)))^0.5) - Qloss(2,8);
    ((x(1)*T(3,8)^2+x(2)*T(3,8)+x(3))*exp((x(4)*T(3,8)+x(5))*Crate(3,8))*Ah(3,8) + f*exp(h/T(3,8))*(Ah(3,8)/(2*x(8)*Q0*Crate(3,8)))^0.5) - Qloss(3,8);
    ((x(1)*T(4,8)^2+x(2)*T(4,8)+x(3))*exp((x(4)*T(4,8)+x(5))*Crate(4,8))*Ah(4,8) + f*exp(h/T(4,8))*(Ah(4,8)/(2*x(8)*Q0*Crate(4,8)))^0.5) - Qloss(4,8);
 
    ((x(1)*T(1,9)^2+x(2)*T(1,9)+x(3))*exp((x(4)*T(1,9)+x(5))*Crate(1,9))*Ah(1,9) + f*exp(h/T(1,9))*(Ah(1,9)/(2*x(9)*Q0*Crate(1,9)))^0.5) - Qloss(1,9);
    ((x(1)*T(2,9)^2+x(2)*T(2,9)+x(3))*exp((x(4)*T(2,9)+x(5))*Crate(2,9))*Ah(2,9) + f*exp(h/T(2,9))*(Ah(2,9)/(2*x(9)*Q0*Crate(2,9)))^0.5) - Qloss(2,9);
    ((x(1)*T(3,9)^2+x(2)*T(3,9)+x(3))*exp((x(4)*T(3,9)+x(5))*Crate(3,9))*Ah(3,9) + f*exp(h/T(3,9))*(Ah(3,9)/(2*x(9)*Q0*Crate(3,9)))^0.5) - Qloss(3,9);
    ((x(1)*T(4,9)^2+x(2)*T(4,9)+x(3))*exp((x(4)*T(4,9)+x(5))*Crate(4,9))*Ah(4,9) + f*exp(h/T(4,9))*(Ah(4,9)/(2*x(9)*Q0*Crate(4,9)))^0.5) - Qloss(4,9);
     
    ((x(1)*T(1,10)^2+x(2)*T(1,10)+x(3))*exp((x(4)*T(1,10)+x(5))*Crate(1,10))*Ah(1,10) + f*exp(h/T(1,10))*(Ah(1,10)/(2*x(9)*Q0*Crate(1,10)))^0.5) - Qloss(1,10);
    ((x(1)*T(2,10)^2+x(2)*T(2,10)+x(3))*exp((x(4)*T(2,10)+x(5))*Crate(2,10))*Ah(2,10) + f*exp(h/T(2,10))*(Ah(2,10)/(2*x(9)*Q0*Crate(2,10)))^0.5) - Qloss(2,10);
    ((x(1)*T(3,10)^2+x(2)*T(3,10)+x(3))*exp((x(4)*T(3,10)+x(5))*Crate(3,10))*Ah(3,10) + f*exp(h/T(3,10))*(Ah(3,10)/(2*x(9)*Q0*Crate(3,10)))^0.5) - Qloss(3,10);
 
    ((x(1)*T(1,11)^2+x(2)*T(1,11)+x(3))*exp((x(4)*T(1,11)+x(5))*Crate(1,11))*Ah(1,11) + f*exp(h/T(1,11))*(Ah(1,11)/(2*x(9)*Q0*Crate(1,11)))^0.5) - Qloss(1,11);
    ((x(1)*T(2,11)^2+x(2)*T(2,11)+x(3))*exp((x(4)*T(2,11)+x(5))*Crate(2,11))*Ah(2,11) + f*exp(h/T(2,11))*(Ah(2,11)/(2*x(9)*Q0*Crate(2,11)))^0.5) - Qloss(2,11);
    ((x(1)*T(3,11)^2+x(2)*T(3,11)+x(3))*exp((x(4)*T(3,11)+x(5))*Crate(3,11))*Ah(3,11) + f*exp(h/T(3,11))*(Ah(3,11)/(2*x(9)*Q0*Crate(3,11)))^0.5) - Qloss(3,11);
    
    (A(x)<0)*1e20;
    (imag(A(x))~=0)*1e20;
    (B(x)>0)*1e20;
    (C(x)<0)*1e20;
    (D(x)>0)*1e20;
    (E(x)<0)*1e20;
    ((D(x)*333.15+E(x))<0)*1e20;
    (W1(x)<1)*1e20;
    (W2(x)<0.5)*1e20;
    (W3(x)<0.1)*1e20;
    (W4(x)<0.01)*1e20;
        
    ];

X0 = [2.0884e-08,-1.2189e-05,0.0018,-1.8487e-05,0.02352,2.5,1,0.5,0.05];
[x,ssq,cnt] = LMFsolve(F,X0);

a = x(1);
b = x(2);
c = x(3);
d = x(4);
e = x(5);
w1 = x(6);
w2 = x(7);
w3 = x(8);
w4 = x(9);

Ah_n = (0:1:7000);

figure()
for j=1:3
    plot(Ah(:,j), Q(:,j),'o')
    hold on 
    Q_loss = (a*T(1,j)^2+b*T(1,j)+c)*exp((d*T(1,j)+e)*Crate(1,j))*Ah_n + f*exp(h/T(1,j))*(Ah_n/(2*w1*Q0*Crate(1,j))).^0.5;
    plot(Ah_n,Q_loss*100/Q0)
    axis([0 7000 0 30]);
    hold on
end
    
figure()
for j=4:6
    plot(Ah(:,j), Q(:,j),'o')
    hold on 
    Q_loss = (a*T(1,j)^2+b*T(1,j)+c)*exp((d*T(1,j)+e)*Crate(1,j))*Ah_n + f*exp(h/T(1,j))*(Ah_n/(2*w2*Q0*Crate(1,j))).^0.5;
    plot(Ah_n,Q_loss*100/Q0)
    axis([0 3500 0 30]);
    hold on
end

figure()
for j=7:8
    plot(Ah(:,j), Q(:,j),'o')
    hold on
    Q_loss = (a*T(1,j)^2+b*T(1,j)+c)*exp((d*T(1,j)+e)*Crate(1,j))*Ah_n + f*exp(h/T(1,j))*(Ah_n/(2*w3*Q0*Crate(1,j))).^0.5;
    plot(Ah_n,Q_loss*100/Q0)    
    axis([0 7000 0 25]);
    hold on
end

% figure()
% for j=9:11
%     plot(Ah(:,j), Q(:,j),'o')
%     hold on
%     Q_loss = (a*T(1,j)^2+b*T(1,j)+c)*exp((d*T(1,j)+e)*Crate(1,j))*Ah_n + f*exp(h/T(1,j))*(Ah_n/(2*w4*Q0*Crate(1,j))).^0.5;
%     plot(Ah_n,Q_loss*100/Q0) 
%     axis([0 6000 0 60]);
%     hold on
% end
% 
% figure()
% T = (253:1:333);
% plot(T,a*T.*T+b*T+c)
% 
% figure()
% plot(T,d*T+e)
% 
% figure()
% Crate = (0.1:0.1:10);
% plot(Crate,exp((d*298.15+e)*Crate))
